<?php
/**
 * Plugin Name:           AutomatorWP - BuddyBoss
 * Plugin URI:            https://automatorwp.com/add-ons/buddyboss/
 * Description:           Connect AutomatorWP with BuddyBoss.
 * Version:               1.7.7
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-buddyboss
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.9
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\BuddyBoss
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_BuddyBoss {

    /**
     * @var         AutomatorWP_BuddyBoss $instance The one true AutomatorWP_BuddyBoss
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_BuddyBoss self::$instance The one true AutomatorWP_BuddyBoss
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_BuddyBoss();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_BUDDYBOSS_VER', '1.7.7' );

        // Plugin file
        define( 'AUTOMATORWP_BUDDYBOSS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_BUDDYBOSS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_BUDDYBOSS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/custom-tables.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/register-specific-field-value.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/account-activation.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/user-suspended.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/user-unsuspended.php';
            // BuddyBoss Follow
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/start-following.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/stop-following.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-follower.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/lose-follower.php';
            // BuddyBoss Email Invites
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/send-email-invite.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/email-invited-registered.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-email-invited-registered.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/email-invited-activated.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-email-invited-activated.php';
            // BuddyBoss Profile
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/update-avatar.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/update-cover.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/update-profile.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/profile-percentage.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/specific-profile-field-value.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/update-member-type.php';
            // BuddyBoss Friendships
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/send-friendship.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/accept-friendship.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-friendship-accepted.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/reject-friendship.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-friendship-rejected.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/remove-friendship.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-friendship-removed.php';
            // BuddyBoss Messages
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/send-message.php';
            // BuddyBoss Activity
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/publish-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/publish-activity-media.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/publish-activity-video.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/publish-activity-document.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/comment-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/favorite-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-favorite-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/remove-like-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-remove-like-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/delete-comment-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/spam-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/react-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-react-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/remove-react-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-remove-react-activity.php';
            // BuddyBoss Groups
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/publish-group-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/comment-activity-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-comment-activity-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/create-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/delete-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/join-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/join-group-type.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/invite-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/invite-group-type.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/request-join-private-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/request-join-private-group-type.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/join-private-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/join-private-group-type.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/reject-private-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/reject-private-group-type.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/leave-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/leave-group-type.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/removed-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/removed-group-type.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/banned-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/banned-group-type.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/user-group-role-changed.php';
            // BuddyBoss Forums
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/create-forum.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/create-topic.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/create-reply.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-reply.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/favorite-topic.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/unfavorite-topic.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/get-favorite.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/delete-topic.php';
            // BuddyBoss Moderation
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/report-topic.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/triggers/report-reply-topic.php';

            // Actions
            // BuddyBoss Profile
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/set-user-member-type.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/update-user-profile-field.php';
            // BuddyBoss Activity
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/add-user-activity.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/add-group-activity.php';
            // BuddyBoss Notifications
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/add-user-notification.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/add-group-notification.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/add-group-roles-notification.php';
            // BuddyBoss Messages
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/send-user-message.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/send-group-message.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/send-group-roles-message.php';
            // BuddyBoss Groups
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/create-new-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/add-user-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/remove-user-group.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/send-group-email.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/send-group-roles-email.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/create-new-subgroup.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/set-user-role.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/accept-user-group-request.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/reject-user-group-request.php';
            // BuddyBoss Friendships
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/user-friendship.php';
            // BuddyBoss Follow
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/following-user.php';
            // BuddyBoss Forums
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/subscribe-user-forum.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/unsubscribe-user-forum.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/create-new-topic.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/create-new-reply.php';
            // BuddyBoss Moderation
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/suspend-user.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/actions/unsuspend-user.php';

            // Filters
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/filters/user-member-type.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/filters/user-profile-field.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/filters/user-in-group-role.php';
            require_once AUTOMATORWP_BUDDYBOSS_DIR . 'includes/filters/user-not-in-group-role.php';
            
        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'buddyboss', array(
            'label' => 'BuddyBoss',
            'icon'  => AUTOMATORWP_BUDDYBOSS_URL . 'assets/buddyboss.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! defined( 'BP_PLATFORM_VERSION' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_BuddyBoss instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_BuddyBoss The one true AutomatorWP_BuddyBoss
 */
function AutomatorWP_BuddyBoss() {
    return AutomatorWP_BuddyBoss::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_BuddyBoss' );
